/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class FilterScreenBlock
extends Block {
    private static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final VoxelShape[] SHAPE = new VoxelShape[]{VoxelShapeHelper.createVoxelShape(6.5, 0.0, 0.0, 3.0, 16.0, 16.0), VoxelShapeHelper.createVoxelShape(0.0, 6.5, 0.0, 16.0, 3.0, 16.0), VoxelShapeHelper.createVoxelShape(0.0, 0.0, 6.5, 16.0, 16.0, 3.0)};

    public FilterScreenBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE[((Direction.Axis)pState.m_61143_(AXIS)).ordinal()];
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.m_5776_() && entityIn instanceof ItemEntity) {
            List<Item> list = FilterScreenBlock.getPassableItem(worldIn, pos);
            if (list.contains(((ItemEntity)entityIn).m_32055_().m_41720_())) {
                return;
            }
            Vec3 motion = entityIn.m_20184_();
            if (motion.f_82479_ != 0.0 || motion.f_82481_ != 0.0) {
                entityIn.m_20334_(0.0, 0.0, 0.0);
            }
        }
    }

    public static List<Item> getPassableItem(Level worldIn, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        while (worldIn.m_8055_(blockPos).m_60734_() instanceof FilterScreenBlock) {
            blockPos = blockPos.m_7494_();
        }
        if (worldIn.m_7702_(blockPos) != null) {
            return worldIn.m_7702_(blockPos).getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> {
                ArrayList list = Lists.newArrayList();
                for (int i = 0; i < h.getSlots(); ++i) {
                    list.add(h.getStackInSlot(i).m_41720_());
                }
                return list;
            }).orElse(Lists.newArrayList());
        }
        return Lists.newArrayList();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41619_()) {
            if (((Direction.Axis)state.m_61143_(AXIS)).equals((Object)Direction.Axis.X)) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z));
            } else {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null) {
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43723_().m_6350_().m_122434_());
        }
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{AXIS}));
    }
}

